﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.ServicesWrapper;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class HospitalLocationDal : BaseDal<HospitalLocation>
    {
        public HospitalLocationDal(VistaSite site) : base(site) { }

        public override void Add(BMS.VistaIntegration.Data.IEntity vistaEntity, HospitalLocation entity)
        {
            EIS_EVSLockWrapper.InsertHospitalLocation(entity, Site.Code);
        }

        public override void Delete(BMS.VistaIntegration.Data.IEntity vistaEntity, HospitalLocation entity)
        {
            EIS.DeleteHospitalLocation(entity.Id);
        }

        public override void Update(BMS.VistaIntegration.Data.IEntity vistaEntity, HospitalLocation entity)
        {
            EIS.UpdateHospitalLocation(entity);
        }

        public override HospitalLocation Get(VistaIntegration.Data.IEntity vistaEntity)
        {
            return EIS.GetHospitalLocation(vistaEntity.IEN, Site.Id);
        }
    }
}
